Independence_1 <- function(Site_Peaks){
  library(IRanges)
  Overlap <- IRanges((Site_Peaks$Event_Base), Site_Peaks$Event_End)
  Site_Peaks$Group <- subjectHits(findOverlaps(Overlap, reduce(Overlap)))
  
  library(data.table)
  Events <- as.data.table(Site_Peaks)
  Events <- data.frame(Events[, list(Event_Base = min(Event_Base), Event_Peak = Event_Peak[which.max(Peak_Discharge)],
                             Event_End = max(Event_End), Peak_Discharge = max(Peak_Discharge)), by = Group])

  return(Events)
}  